#include <amxmodx>
#include <umitem>
#include <fun>

#define RegenRate	2.0
#define RegenPoints	10

new PLUGIN_NAME[] 	= "UM Item: HP Regen"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"

new bool:g_HPRegen[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Health Regeneration", "Regenerate's Health", 1500)
	register_event("ResetHUD", "Event_ResetHUD", "be")
	register_event("DeathMsg", "Event_DeathMsg", "a")
}

public client_connect(id) {
	g_HPRegen[id] = false
}

public Event_ResetHUD(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(g_HPRegen[id]) 
	{
		if(!task_exists(id)) {
			set_task(RegenRate, "Task_HealthRegen", id, _, _, "b")
		}
	}
	return PLUGIN_CONTINUE
}

public Event_DeathMsg() {
	if(task_exists(read_data(2))) {
		remove_task(read_data(2))
	}
}

public Enable_Item(id) 
{
	g_HPRegen[id] = true
	set_task(RegenRate, "Task_HealthRegen", id, _, _, "b")
}

public Disable_Item(id) 
{
	g_HPRegen[id] = false
	if(task_exists(id)) {
		remove_task(id)
	}
}

public Task_HealthRegen(id) 
{  
	if(!is_user_alive(id) || !is_user_connected(id) || !g_HPRegen[id]) 
	{
		if(task_exists(id)) {
			remove_task(id)
		}
		return PLUGIN_CONTINUE
	}
	
	new iHealth = get_user_health(id)
	if(iHealth < 100) 
	{
		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), { 0, 0, 0 }, id)
		write_short(1<<10) 
		write_short(1<<10)
		write_short(1<<12) 
		write_byte(0) 
		write_byte(0)
		write_byte(255)
		write_byte(50)
		message_end()
		
		iHealth += RegenPoints
		set_user_health(id, iHealth) 
		if(get_user_health(id) > 100) {
			set_user_health(id, 100)
		}
	}
	return PLUGIN_CONTINUE
}
